% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_on.R
\name{standardization_scale}
\alias{standardization_scale}
\title{pooled dispersion for a numeric variable}
\usage{
standardization_scale(x, trtgrp, standardizer = NULL, svydesign_ = NULL)
}
\arguments{
\item{x}{numeric variable}

\item{trtgrp}{logical or numeric. If numeric, coerced to logical via \code{!}}

\item{standardizer}{function, \code{NULL} or numeric of length 1}

\item{svydesign_}{ordinarily \code{NULL}, but may also be a
\code{survey.design2}; see Details.}
}
\value{
numeric of length 1
}
\description{
Dispersion as pooled across a treatment and a control group. By default,
the measure of dispersion calculated within each group is not the
ordinary standard deviation as in \code{stats::sd} but rather the robust alternative
encoded in \code{stats::mad}.  The dispersion measurements are combined
by squaring, averaging with weights proportional to one minus the sizes of
the groups and then taking square roots.  Used in \code{\link{match_on.glm}}.
}
\details{
A non-NULL \code{svydesign_} parameter indicates that the dispersion
calculations are to be made respecting the weighting scheme implicit in
that \code{survey.design2} object. If \code{standardizer} is \code{NULL},
one gets a calculation in the style of \code{stats::mad} but with weights,
performed by \code{optmatch:::svy_sd}; for a pooling of weighted standard
deviations, one would pass a non-\code{NULL} \code{svydesign_} parameter along
with \code{standardizer=optmatch:::svy_sd}.
(More generally, the provided \code{standardizer}
function should accept as a sole argument a \code{survey.design2} object,
with \code{nrows(svydesign_$variables)} equal to the lengths of \code{x} and
\code{trtgrp}.  This object is expected to carry a numeric variable \sQuote{\code{x}},
and the \code{standardizer} function is to return the dispersion of this variable.)
}
\keyword{internal}
