% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_get_tables}
\alias{wb_get_tables}
\title{List Excel tables in a worksheet}
\usage{
wb_get_tables(wb, sheet = current_sheet())
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}
}
\value{
A character vector of table names on the specified sheet
}
\description{
List Excel tables in a worksheet
}
\examples{

wb <- wb_workbook()
wb$add_worksheet(sheet = "Sheet 1")
wb$add_data_table(x = iris)
wb$add_data_table(x = mtcars, table_name = "mtcars", start_col = 10)

wb$get_tables(sheet = "Sheet 1")
}
