% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_translation.R
\name{create_translation}
\alias{create_translation}
\title{Create translation}
\usage{
create_translation(
  file,
  model = "whisper-1",
  prompt = NULL,
  response_format = "json",
  temperature = 0,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{file}{required; a length one character vector.}

\item{model}{required; a length one character vector equals to \code{"whisper-1"}.}

\item{prompt}{optional; defaults to \code{NULL}; a length one character vector.}

\item{response_format}{required; defaults to \code{"json"}; length one character
vector equals to \code{"json"}. \strong{Currently only \code{"json"} is implemented.}}

\item{temperature}{required; defaults to \code{1}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain a transcription and
supplementary information.
}
\description{
Translates audio into into English. See
\href{https://platform.openai.com/docs/api-reference/audio/create}{this page}
for details.
}
\details{
For arguments description please refer to the \href{https://platform.openai.com/docs/api-reference/audio/create}{official documentation}.
}
\examples{
\dontrun{
voice_sample_ua <- system.file(
    "extdata", "sample-ua.m4a", package = "openai"
)
create_translation(file = voice_sample_ua)
}
}
\seealso{
Other audio functions: 
\code{\link{create_transcription}()}
}
\concept{audio functions}
