% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.users.R
\name{oadmin.user_add}
\alias{oadmin.user_add}
\title{Add a user}
\usage{
oadmin.user_add(opal, name, groups = NULL, password = NULL)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{User name}

\item{groups}{User groups}

\item{password}{User password. If not provided, a password will be generated and returned.}
}
\description{
Add a user in Opal internal users registry.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
pwd <- oadmin.user_add(o, "foo", groups = c("datashield", "CNSIM"))
opal.logout(o)
}
}
\seealso{
Other user functions: 
\code{\link{oadmin.user_delete}()},
\code{\link{oadmin.user_enable}()},
\code{\link{oadmin.user_exists}()},
\code{\link{oadmin.user_profile_delete}()},
\code{\link{oadmin.user_profiles}()},
\code{\link{oadmin.user_reset_password}()},
\code{\link{oadmin.users}()}
}
\concept{user functions}
