% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.perm.R
\name{opal.perms}
\alias{opal.perms}
\title{Get the permissions of a subject}
\usage{
opal.perms(opal, subject, type = "user")
}
\arguments{
\item{opal}{Opal connection object.}

\item{subject}{A subject identifier: user or group name.}

\item{type}{The type of subject: user (default) or group.}
}
\value{
A data.frame with columns: subject, type, target (path to the opal object to which 
the permission applies), target_type and perm (the permission name)
}
\description{
Get the permissions of a subject. If the subject is a user, the permissions of
the groups to which the user belongs are also added to the result.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.table_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.perms(o, 'andrei')
opal.table_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
\seealso{
Other table functions: 
\code{\link{opal.resource_view_create}()},
\code{\link{opal.resource_view_reconnect}()},
\code{\link{opal.table_create}()},
\code{\link{opal.table_delete}()},
\code{\link{opal.table_dictionary_get}()},
\code{\link{opal.table_dictionary_update}()},
\code{\link{opal.table_exists}()},
\code{\link{opal.table_export}()},
\code{\link{opal.table_get}()},
\code{\link{opal.table_import}()},
\code{\link{opal.table_perm_add}()},
\code{\link{opal.table_perm_delete}()},
\code{\link{opal.table_perm}()},
\code{\link{opal.table_save}()},
\code{\link{opal.table_truncate}()},
\code{\link{opal.table_view_create}()},
\code{\link{opal.table_view_update}()}
}
\concept{table functions}
