% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhpp_functions.R
\name{integrate_edge_KDE}
\alias{integrate_edge_KDE}
\title{Calculate KDE integral over edges}
\usage{
integrate_edge_KDE(tree.discr, Edge.KDE.list)
}
\arguments{
\item{tree.discr}{simmap or phylo object. A discretized tree using the 'discr_Simmap' function.}

\item{Edge.KDE.list}{list. A list with the normalized KDEs or loess smoothing for each edge.}
}
\value{
A numeric value for the integral over all edges.
}
\description{
Checks the integral of normalized Markov KDE or normalized loess smoothing over edges.
}
\examples{
data("hym_kde", "hym_tree")
# Get reference tree.
tree_discr <- discr_Simmap(hym_tree, res = 200)
# Get non-normalized and normalized edge KDE data for mean rates.
Edge_KDE <- hym_kde$head
# Check integrals.
integrate_edge_KDE(tree_discr, Edge_KDE$Maps.mean.norm)
integrate_edge_KDE(tree_discr, Edge_KDE$Maps.mean.loess.norm)

}
\author{
Sergei Tarasov
}
