% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_zeros.R
\name{check_zeros}
\alias{check_zeros}
\title{Check data for zeros across samples within factor levels.
Will determine if there are more zeros than a user specified threshold within any given factor level(s). Returns
a vector of Metabolites that are 0 above the threshold in any given factor level.}
\usage{
check_zeros(
  count_data,
  metadata,
  numerator = NULL,
  denominator = NULL,
  threshold = 25,
  response_variable = "Metabolite",
  Factor
)
}
\arguments{
\item{count_data}{A metabolomics count data frame}

\item{metadata}{Metadata dataframe for the metabolomics count data frame}

\item{numerator}{String of the first independent variable you wish to test. Defualt is NULL}

\item{denominator}{String of the second independent variable you wish to test. Default is NULL.}

\item{threshold}{Integer. A percentage threshold for the number of zeros in a Metabolite. Default is 25.}

\item{response_variable}{String of the column header for the response variables,
usually "Metabolite"}

\item{Factor}{A factor with levels to test for zeros.}
}
\description{
Check data for zeros across samples within factor levels.
Will determine if there are more zeros than a user specified threshold within any given factor level(s). Returns
a vector of Metabolites that are 0 above the threshold in any given factor level.
}
\examples{

check_zeros(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
Factor = "Treatment")
\dontshow{c57_nos2KO_mouse_countDF[1,3:31] <- 0}
check_zeros(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
Factor = "Treatment",numerator = "Strep", denominator = "Mock", threshold = 10)
}
