% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_heatmap.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Create a heatmap}
\usage{
plot_heatmap(
  count_data,
  metadata,
  Factor,
  response_variable,
  log_transform,
  high_color,
  low_color,
  aggregate_by
)
}
\arguments{
\item{count_data}{A metabolomics count data frame.}

\item{metadata}{The descriptive meta data for the samples.}

\item{Factor}{The column name for the experimental variable.}

\item{response_variable}{The response variable for the data, i.e. "Metabolite"}

\item{log_transform}{TRUE or FALSE. Recommended for visualization purposes. If true data is
transformed by the natural log.}

\item{high_color}{Color for high abundance values}

\item{low_color}{Color for low abundance values}

\item{aggregate_by}{Hierarchical metadata value to sum metabolite values by, i.e. "Class"}
}
\description{
Takes a metabolomics count data frame and creates a heatmap. It is recommended to
either subset, truncate, or agglomerate by hierarchical metadata to reduce noise.
}
\examples{
c57_nos2KO_mouse_countDF <- assign_hierarchy(c57_nos2KO_mouse_countDF, TRUE, "KEGG")

plot_heatmap(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
log_transform = TRUE, Factor = "Treatment", response_variable = "Metabolite",
aggregate_by = "Subclass_2", high_color = "darkgoldenrod1", low_color = "dodgerblue2")
}
