% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_detection.R
\name{label_detection}
\alias{label_detection}
\title{Label detections from a sound event detection procedure}
\usage{
label_detection(reference, detection, cores = 1, pb = TRUE)
}
\arguments{
\item{reference}{Data frame or 'selection.table' (following the warbleR package format) with the reference selections (start and end of the sound events) that will be used to evaluate the performance of the detection, represented by those selections in 'detection'. Must contained at least the following columns: "sound.files", "selec", "start" and "end". \strong{It must contain the reference selections that will be used for detection optimization}.}

\item{detection}{Data frame or 'selection.table' with the detections (start and end of the sound events) that will be compared against the 'reference' selections. Must contained at least the following columns: "sound.files", "selec", "start" and "end". It can contain data for additional sound files not found in 'references'. In this case the routine assumes that no sound events are found in those files, so detection from those files are all false positives.}

\item{cores}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}
}
\value{
A data frame or selection table (if 'detection' was also a selection table, warbleR package's format, see \code{\link[warbleR]{selection_table}}) including the columns in 'detection' plus 3 additional columns:
\itemize{
 \item \code{detection.class}: indicates the class of each detection. Eight possible labels: 'true.positive', 'false.positive', 'true.positive (split)', 'true.positive (merged)',  'true.positive (split/merged)', 'false.positive (split)', 'false.positive (merged)' and 'galse.positive (split/merged)'.  See \code{\link{diagnose_detection}} for a description.
 \item \code{reference.row}: contains the index of the row in 'reference' of the reference sound event that is overlapped in time by the detection (not supplied for false positives).
 \item \code{overlap}: contains the proportion of the reference sound event that is overlapped in time by the detection (not supplied for false positives).
 }
}
\description{
\code{label_detection} labels the performance of a sound event detection procedure comparing the output selection table to a reference selection table
}
\details{
The function identifies the rows in the output of a detection routine as true or false positives. This is achieved by comparing the data frame to a reference selection table in which all sound events of interest have been selected.
}
\examples{
{
# load data
data("lbh_reference")

# an extra one in detection (1 false positive)
label_detection(reference = lbh_reference[-1, ], detection = lbh_reference)

# missing one in detection (all true positives)
label_detection(reference = lbh_reference, detection = lbh_reference[-1, ])

# perfect detection (all true positives)
label_detection(reference = lbh_reference, detection = lbh_reference)

# and extra sound file in reference (all true positives)
label_detection(reference = lbh_reference, detection =
lbh_reference[lbh_reference$sound.files != "lbh1.wav", ])

# and extra sound file in detection (some false positives)
label_detection(reference =
lbh_reference[lbh_reference$sound.files != "lbh1.wav", ],
detection = lbh_reference)

# duplicate 1 detection row (to get 2 splits)
label_detection(reference = lbh_reference,
detection = lbh_reference[c(1, 1:nrow(lbh_reference)), ])

# merge 2 detections (to get split and merge)
Y <- lbh_reference
Y$end[1] <- 1.2
label_detection(reference = lbh_reference, detection = Y)

# remove split to get only merge
Y <- Y[-2, ]
label_detection(reference = lbh_reference, detection = Y)
}
}
\references{
{
Araya-Salas, M. (2021), ohun: diagnosing and optimizing automated sound event detection. R package version 0.1.0.
}
}
\seealso{
\code{\link{diagnose_detection}}, \code{\link{summarize_diagnostic}}
}
\author{
Marcelo Araya-Salas \email{marcelo.araya@ucr.ac.cr})
}
