% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_add_plot}
\alias{body_add_plot}
\title{Add plot in a 'Word' document}
\usage{
body_add_plot(
  x,
  value,
  width = 6,
  height = 5,
  res = 300,
  style = "Normal",
  pos = "after",
  ...
)
}
\arguments{
\item{x}{an rdocx object}

\item{value}{plot instructions, see \code{\link[=plot_instr]{plot_instr()}}.}

\item{width}{height in inches}

\item{height}{height in inches}

\item{res}{resolution of the png image in ppi}

\item{style}{paragraph style}

\item{pos}{where to add the new element relative to the cursor,
one of "after", "before", "on".}

\item{...}{Arguments to be passed to png function.}
}
\description{
Add a plot as a png image into an rdocx object.
}
\examples{
doc <- read_docx()

if (capabilities(what = "png")) {
  doc <- body_add_plot(doc,
    value = plot_instr(
      code = {
        barplot(1:5, col = 2:6)
      }
    ),
    style = "centered"
  )
}

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()}
}
\concept{functions for adding content}
