% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oem_xval.R
\name{xval.oem}
\alias{xval.oem}
\title{Orthogonalizing EM}
\usage{
xval.oem(x, y, nfolds = 10L, foldid = NULL, type.measure = c("mse",
  "deviance", "class", "auc", "mae"), ncores = -1, family = c("gaussian",
  "binomial"), penalty = c("elastic.net", "lasso", "ols", "mcp", "scad",
  "grp.lasso"), weights = numeric(0), lambda = numeric(0), nlambda = 100L,
  lambda.min.ratio = NULL, alpha = 1, gamma = 3, groups = numeric(0),
  penalty.factor = NULL, group.weights = NULL, standardize = TRUE,
  intercept = TRUE, maxit = 500L, tol = 1e-07, irls.maxit = 100L,
  irls.tol = 0.001, compute.loss = FALSE)
}
\arguments{
\item{x}{input matrix (sparse matrices not yet implemented). 
Each row is an observation, each column corresponds to a covariate}

\item{y}{numeric response vector of length \code{nobs = nrow(x)}.}

\item{nfolds}{integer number of cross validation folds. 3 is the minimum number allowed. defaults to 10}

\item{foldid}{an optional vector of values between 1 and \code{nfold} specifying which fold each observation belongs to.}

\item{type.measure}{measure to evaluate for cross-validation. The default is \code{type.measure = "deviance"}, 
which uses squared-error for gaussian models (a.k.a \code{type.measure = "mse"} there), deviance for logistic
regression. \code{type.measure = "class"} applies to \code{binomial} only. \code{type.measure = "auc"} is for two-class logistic 
regression only. \code{type.measure="mse"} or \code{type.measure="mae"} (mean absolute error) can be used by all models;
they measure the deviation from the fitted mean to the response.}

\item{ncores}{Integer scalar that specifies the number of threads to be used}

\item{family}{\code{"gaussian"} for least squares problems, \code{"binomial"} for binary response (not implemented yet).}

\item{penalty}{Specification of penalty type in lowercase letters. Choices include \code{"lasso"}, 
\code{"ols"} (Ordinary least squares, no penaly), \code{"elastic.net"}, \code{"scad"}, \code{"mcp"}, \code{"grp.lasso"}}

\item{weights}{observation weights. defaults to 1 for each observation (setting weight vector to 
length 0 will default all weights to 1)}

\item{lambda}{A user supplied lambda sequence. By default, the program computes
its own lambda sequence based on \code{nlambda} and \code{lambda.min.ratio}. Supplying
a value of lambda overrides this.}

\item{nlambda}{The number of lambda values - default is 100.}

\item{lambda.min.ratio}{Smallest value for lambda, as a fraction of \code{lambda.max}, the (data derived) entry
value (i.e. the smallest value for which all coefficients are zero). The default
depends on the sample size nobs relative to the number of variables nvars. If
\code{nobs > nvars}, the default is 0.0001, close to zero.}

\item{alpha}{mixing value for elastic.net. penalty applied is (1 - alpha) * (ridge penalty) + alpha * (lasso penalty)}

\item{gamma}{tuning parameter for SCAD and MCP penalties. must be >= 1}

\item{groups}{A vector of describing the grouping of the coefficients. See the example below. All unpenalized variables
should be put in group 0}

\item{penalty.factor}{Separate penalty factors can be applied to each coefficient. 
This is a number that multiplies lambda to allow differential shrinkage. Can be 0 for some variables, 
which implies no shrinkage, and that variable is always included in the model. Default is 1 for all 
variables.}

\item{group.weights}{penalty factors applied to each group for the group lasso. Similar to \code{penalty.factor}, 
this is a number that multiplies lambda to allow differential shrinkage. Can be 0 for some groups, 
which implies no shrinkage, and that group is always included in the model. Default is sqrt(group size) for all
groups.}

\item{standardize}{Logical flag for \code{x} variable standardization, prior to fitting the models. 
The coefficients are always returned on the original scale. Default is \code{standardize = TRUE}. If 
variables are in the same units already, you might not wish to standardize.}

\item{intercept}{Should intercept(s) be fitted (\code{default = TRUE}) or set to zero (\code{FALSE})}

\item{maxit}{integer. Maximum number of OEM iterations}

\item{tol}{convergence tolerance for OEM iterations}

\item{irls.maxit}{integer. Maximum number of IRLS iterations}

\item{irls.tol}{convergence tolerance for IRLS iterations. Only used if \code{family != "gaussian"}}

\item{compute.loss}{should the loss be computed for each estimated tuning parameter? Defaults to \code{FALSE}. Setting
to \code{TRUE} will dramatically increase computational time}
}
\value{
An object with S3 class \code{"xval.oem"}
}
\description{
Orthogonalizing EM
}
\examples{
set.seed(123)
n.obs <- 1e4
n.vars <- 100

true.beta <- c(runif(15, -0.25, 0.25), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

system.time(fit <- oem(x = x, y = y, 
                       penalty = c("lasso", "grp.lasso"), 
                       groups = rep(1:20, each = 5)))
                       
system.time(xfit <- xval.oem(x = x, y = y, 
                             penalty = c("lasso", "grp.lasso"), 
                             groups = rep(1:20, each = 5)))

}

