% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insert_matrix_column.R
\name{insert_matrix_column}
\alias{insert_matrix_column}
\title{Insert column in matrix}
\usage{
insert_matrix_column(A, x, p)
}
\arguments{
\item{A}{A \code{matrix}.}

\item{x}{A \code{vector} of length \code{nrow(A)}, the column to be added.

Can also be a single value.}

\item{p}{An \code{integer}, the position where to add the column:
\itemize{
\item \code{p = 0} appends the column left
\item \code{p = ncol(A)} appends the column right
\item \code{p = n} inserts the column between the \code{n}-th and
\code{(n + 1)}-th column of \code{A}.
}

Can also be a \code{vector} of multiple positions.}
}
\value{
A \code{matrix}.
}
\description{
This function inserts a column into a matrix.
}
\examples{
A <- diag(3)
x <- 1:3
insert_matrix_column(A, x, 0)
insert_matrix_column(A, x, 1)
insert_matrix_column(A, x, 2)
insert_matrix_column(A, x, 3)

### also single value
x <- 2
insert_matrix_column(A, x, 0)

### also multiple positions
insert_matrix_column(A, x, 0:3)

### also trivial case
insert_matrix_column(matrix(nrow = 0, ncol = 0), integer(), integer())
}
