% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.2m.R
\name{od.2m}
\alias{od.2m}
\title{Optimal sample allocation calculation for two-level multisite randomized trials}
\usage{
od.2m(n = NULL, p = NULL, icc = NULL, r12 = NULL, r22m = NULL,
  c1 = NULL, c2 = NULL, c1t = NULL, omega = NULL, m = NULL,
  plots = TRUE, plot.by = NULL, nlim = NULL, plim = NULL,
  varlim = NULL, nlab = NULL, plab = NULL, varlab = NULL,
  vartitle = NULL, verbose = TRUE, iter = 100, tol = 1e-10)
}
\arguments{
\item{n}{the level-1 sample size per level-2 unit.}

\item{p}{the proportion of level-4 clusters/units to be assigned to treatment.}

\item{icc}{the unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{r12}{the proportion of level-1 variance explained by covariates.}

\item{r22m}{the proportion of variance of site-specific treatment effect explained by covariates.}

\item{c1}{the cost of sampling one level-1 unit in control condition.}

\item{c2}{the cost of sampling one level-2 unit in control condition.}

\item{c1t}{the cost of sampling one level-1 unit in treatment condition.}

\item{omega}{the standardized variance of site-specific treatment effect}

\item{m}{total budget, default is the total costs of sampling 60
level-2 units.}

\item{plots}{logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plot.by}{specify variance plot by \code{n} and/or \code{p};
default value is plot.by = list(n = "n", p = "p").}

\item{nlim}{the plot range for n, default value is c(2, 50).}

\item{plim}{the plot range for p, default value is c(0, 1).}

\item{varlim}{the plot range for variance, default value is c(0, 0.05).}

\item{nlab}{the plot label for \code{n},
default value is "Level-1 Sample Size: n".}

\item{plab}{the plot label for \code{p},
default value is "Proportion Level-1 Units in Treatment: p".}

\item{varlab}{the plot label for variance,
default value is "Variance".}

\item{vartitle}{the title of variance plot, default value is NULL.}

\item{verbose}{logical; print the values of \code{n}
and \code{p} if TRUE, otherwise not; default value is TRUE.}

\item{iter}{number of iterations; default value is 100.}

\item{tol}{tolerance for convergence; default value is 1e-10.}
}
\value{
unconstrained or constrained optimal sample allocation
    (\code{n} and \code{p}).
    The function also returns the variance of treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of two-level
    multisite randomized trials (MRTs) is to choose
    the sample allocation that minimizes the variance of
    treatment effect under fixed budget and cost structure.
    The optimal design parameters include
    the level-1 sample size per level-2 unit (\code{n})
    and the proportion of level-2 unit to be assigned to treatment (\code{p}).
    This function solves the optimal \code{n} and/or \code{p}
    with and without constraints.
}
\examples{
# unconstrained optimal design #---------
  myod1 <- od.2m(icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005))
  myod1$out # n = 20, p =0.37
# plots by p
  myod1 <- od.2m(icc = 0.2, omega = 0.02,
              r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005), plot.by = list(p = 'p'))

# constrained optimal design with p = 0.5 #---------
  myod2 <- od.2m(icc = 0.2, omega = 0.02,
              r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005), p = 0.5)
  myod2$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.86

# constrained optimal design with n = 5 #---------
  myod3 <- od.2m(icc = 0.2, omega = 0.02,
              r12 = 0.5, r22m = 0.5, c1 = 1, c2 = 10,
              c1t = 10, varlim = c(0, 0.005), n = 5)
  myod3$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod3)
  myre$re # RE = 0.79

# constrained n and p, no calculation performed #---------
  myod4 <- od.2m(icc = 0.2, omega = 0.02, r12 = 0.5, r22m = 0.5,
              c1 = 1, c2 = 10, c1t = 10,
              varlim = c(0, 0.005), p = 0.5, n = 10)
  myod4$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod4)
  myre$re # RE = 0.84

}
\references{
Shen, Z. (in progress). Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
