% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ir_deserialise.R
\name{odin_ir_deserialise}
\alias{odin_ir_deserialise}
\title{Deserialise odin's IR}
\usage{
odin_ir_deserialise(x)
}
\arguments{
\item{x}{An intermediate representation as a json string}
}
\value{
A named list
}
\description{
Deserialise odin's intermediate model representation from a json
string into an R object.  Unlike the json, there is no schema for
this representation.  This function provides access to the same
deserialisation that odin uses internally so may be useful in
applications.
}
\examples{
# Parse a model of exponential decay
ir <- odin::odin_parse({
  deriv(y) <- -0.5 * y
  initial(y) <- 1
})
# Convert the representation to an R object
odin::odin_ir_deserialise(ir)
}
\seealso{
\code{\link{odin_parse}}
}
