% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_module.R
\name{filter_ui}
\alias{filter_ui}
\alias{filter_server}
\title{NOAA filter module}
\usage{
filter_ui(id, extended = TRUE)

filter_server(
  id,
  NOAA,
  external,
  ivars = c("depth", "lon", "lat"),
  variable,
  extended = TRUE
)
}
\arguments{
\item{id}{Namespace id shiny module.}

\item{extended}{Boolean whether to build the extended module
(default = \code{TRUE}).}

\item{NOAA}{Reactive value for the dataset containing the locations
coordinates.}

\item{external}{Reactive values for latitude, longitude and depth from plot
module.}

\item{ivars}{Character vector for the variables for filtering.}

\item{variable}{Reactivevalues for selected variable information.}
}
\value{
Shiny module.
}
\description{
This shiny module (\code{filter_ui()} + \code{filter_server()}) allows filtering of
the currently loaded NOAA data via shiny \code{textInput()} interfaces.
}
\examples{

# run filter module stand-alone
if (curl::has_internet() && interactive()) {

library(oceanexplorer)
library(shiny)

# data
NOAA <- get_NOAA("oxygen", 1, "annual")

# gui
ui <- fluidPage(filter_ui("filter"), plot_ui("worldmap"))

# server
server <-function(input, output, session) {
 # table
 filter <- filter_server(
  "filter",
  reactive(NOAA),
  external = reactiveValues(lon = 190, lat = 33, depth = 20),
  variable = reactiveValues(variable = "temperature")
 )

 # plot data
 output_plot <- plot_server("worldmap", reactive(NOAA), filter$coord)
 }

 # run app
 shinyApp(ui, server)
 }
}
