% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{longitudeTighten}
\alias{longitudeTighten}
\title{Try to Reduce Section Longitude Range}
\usage{
longitudeTighten(section)
}
\arguments{
\item{section}{a \linkS4class{section} object.}
}
\value{
A \linkS4class{section} object based on its first argument, but with
longitudes shifted in its \code{metadata} slot, and also in the \code{metadata} slots
of each of the \linkS4class{ctd} objects that are stored in the \code{station} item
in its \code{data} slot.
}
\description{
\link{longitudeTighten} shifts some longitudes in its first argument by 360 degrees, if doing
so will reduce the overall longitude span.
}
\details{
This function can be helpful in cases where the CTD stations within a section
cross the cut point of the longitude convention, which otherwise might
yield ugly plots if \code{\link[=plot,section-method]{plot,section-method()}} is used with \code{xtype="longitude"}.
This problem does occur with CTD objects ordered by time of sampling,
but was observed in December 2020 for a GO-SHIPS dataset downloaded from
\verb{https://cchdo.ucsd.edu/data/15757/a10_1992_ct1}.
}
\author{
Dan Kelley
}
