% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\docType{data}
\name{section}
\alias{section}
\title{Hydrographic section}
\source{
This is based on the WOCE file named \code{a03_hy1.csv}, downloaded
from \url{https://cchdo.ucsd.edu/cruise/90CT40_1}, 13 April 2015.
}
\usage{
data(section)
}
\description{
This is line A03 (ExpoCode 90CT40_1, with nominal sampling date 1993-09-11).
The chief scientist was Tereschenkov of SOI, working aboard the Russian ship
Multanovsky, undertaking a westward transect from the Mediterranean outflow
region across to North America, with a change of heading in the last few dozen
stations to run across the nominal Gulf Stream axis.
The data flags follow the "WHP Bottle"convention, set by
\code{\link[=initializeFlagScheme,section-method]{initializeFlagScheme,section-method()}} to \code{"WHP bottle"}; see
\url{https://www.nodc.noaa.gov/woce/woce_v3/wocedata_1/whp/exchange/exchange_format_desc.htm}
for more information on World Hydrographic Program flag conventions.
}
\examples{
\dontrun{
library(oce)
# Gulf Stream
data(section)
GS <- subset(section, 109<=stationId&stationId<=129)
GSg <- sectionGrid(GS, p=seq(0, 5000, 100))
plot(GSg, map.xlim=c(-80,-60))
}

}
\seealso{
Other datasets provided with oce: 
\code{\link{adp}},
\code{\link{adv}},
\code{\link{argo}},
\code{\link{cm}},
\code{\link{coastlineWorld}},
\code{\link{ctdRaw}},
\code{\link{ctd}},
\code{\link{echosounder}},
\code{\link{landsat}},
\code{\link{lisst}},
\code{\link{lobo}},
\code{\link{met}},
\code{\link{ocecolors}},
\code{\link{rsk}},
\code{\link{sealevelTuktoyaktuk}},
\code{\link{sealevel}},
\code{\link{topoWorld}},
\code{\link{wind}},
\code{\link{xbt}}

Other things related to section data: 
\code{\link{[[,section-method}},
\code{\link{[[<-,section-method}},
\code{\link{as.section}()},
\code{\link{handleFlags,section-method}},
\code{\link{initializeFlagScheme,section-method}},
\code{\link{plot,section-method}},
\code{\link{read.section}()},
\code{\link{section-class}},
\code{\link{sectionAddStation}()},
\code{\link{sectionGrid}()},
\code{\link{sectionSmooth}()},
\code{\link{sectionSort}()},
\code{\link{subset,section-method}},
\code{\link{summary,section-method}}
}
\concept{datasets provided with oce}
\concept{things related to section data}
