% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{tidemVuf}
\alias{tidemVuf}
\title{Nodal Modulation Calculations for Tidem}
\usage{
tidemVuf(t, j, latitude = NULL)
}
\arguments{
\item{t}{The time in \code{POSIXct} format.  (It is \strong{very} important to
use \code{tz="GMT"} in constructing \code{t}.)}

\item{j}{Indices of tidal constituents to use.}

\item{latitude}{Optional numerical value containing the latitude in degrees North.}
}
\value{
A \code{\link[base]{list}} containing
items named \code{v}, \code{u} and \code{f} (see the \code{T_TIDE}
documentation).
}
\description{
Do nodal modulation calculations for \code{\link{tidem}}. This function is based directly
on \code{t_vuf} in the \code{T_TIDE} Matlab package [1].
}
\examples{
tidemVuf(as.POSIXct("2008-01-22 18:50:24"), 43, 45.0)

}
\references{
1. Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002.  Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
\seealso{
Other things related to tides: \code{\link{[[,tidem-method}},
  \code{\link{[[<-,tidem-method}}, \code{\link{as.tidem}},
  \code{\link{plot,tidem-method}},
  \code{\link{predict.tidem}},
  \code{\link{summary,tidem-method}},
  \code{\link{tidedata}}, \code{\link{tidem-class}},
  \code{\link{tidemAstron}}, \code{\link{tidem}},
  \code{\link{webtide}}
}
\author{
Dan Kelley translated this from \code{t_astron} from the \code{T_TIDE}
package.
}
\concept{things related to tides}
