% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapAxis}
\alias{mapAxis}
\title{Add Axis Labels to an Existing Map}
\usage{
mapAxis(side = 1:2, longitude = NULL, latitude = NULL, tick = TRUE,
  line = NA, pos = NA, outer = FALSE, font = NA, lty = "solid",
  lwd = 1, lwd.ticks = lwd, col = NULL, col.ticks = NULL, hadj = NA,
  padj = NA, tcl = -0.3, cex.axis = 1, mgp = c(0, 0.5, 0),
  debug = getOption("oceDebug"))
}
\arguments{
\item{side}{the side at which labels are to be drawn.  If not provided,
sides 1 and 2 will be used (i.e. bottom and left-hand sides).}

\item{longitude}{vector of longitudes to indicate.  If not provided, and if
a grid has already been drawn, then the labels will be at the
intersections of the grid lines with the plotting box.}

\item{latitude}{vector of latitudes to indicate.  If not provided, and if a
grid has already been drawn, then the labels will be at the
interesections of the grid lines with the plotting box.}

\item{tick}{parameter passed to \code{\link{axis}}.}

\item{line}{parameter passed to \code{\link{axis}}.}

\item{pos}{parameter passed to \code{\link{axis}}.}

\item{outer}{parameter passed to \code{\link{axis}}.}

\item{font}{axis font, passed to \code{\link{axis}}.}

\item{lty}{axis line type, passed to \code{\link{axis}}.}

\item{lwd}{axis line width, passed to \code{\link{axis}}).}

\item{lwd.ticks}{tick line width, passed to \code{\link{axis}}.}

\item{col}{axis colour, passed to \code{\link{axis}}.}

\item{col.ticks}{axis tick colour, passed to \code{\link{axis}}.}

\item{hadj}{an argument that is transmitted to \code{\link{axis}}.}

\item{padj}{an argument that is transmitted to \code{\link{axis}}.}

\item{tcl}{axis-tick size (see \code{\link{par}}).}

\item{cex.axis}{axis-label expansion factor (see \code{\link{par}}).}

\item{mgp}{three-element numerical vector describing axis-label
placement (see \code{\link{par}}). It usually makes sense to set
the first and third elements to zero.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}
}
\description{
Plot axis labels on an existing map.
}
\details{
This function is still in development, and the argument list as well as the
action taken are both subject to change, hence the brevity of this help page.

Note that if a grid line crosses the axis twice, only one label will be drawn.
}
\examples{
\dontrun{
library(oce)
data(coastlineWorld)
par(mar=c(2, 2, 3, 1))
lonlim <- c(-180, 180)
latlim <- c(60, 120)
mapPlot(coastlineWorld, projection="+proj=stere +lat_0=90",
        longitudelim=lonlim, latitudelim=latlim,
        grid=FALSE)
mapGrid(15, 15, polarCircle=1/2)
mapAxis()
}

}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapText}}, \code{\link{mapTissot}},
  \code{\link{oceCRS}}, \code{\link{shiftLongitude}},
  \code{\link{usrLonLat}}, \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
