% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{applyMagneticDeclination}
\alias{applyMagneticDeclination}
\title{Earth magnetic declination}
\usage{
applyMagneticDeclination(x, declination = 0, debug = getOption("oceDebug"))
}
\arguments{
\item{x}{an oce object.}

\item{declination}{magnetic declination (to be added to the heading)}

\item{debug}{a debugging flag, set to a positive value to get debugging.}
}
\value{
Object, with velocity components adjusted to be aligned with
geographic north and east.
}
\description{
Instruments that use magnetic compasses to determine current direction need
to have corrections applied for magnetic declination, to get currents with
the y component oriented to geographic, not magnetic, north.  Sometimes, and
for some instruments, the declination is specified when the instrument is
set up, so that the velocities as recorded are already.  Other times, the
data need to be adjusted.  This function is for the latter case.
}
\references{
\samp{https://www.ngdc.noaa.gov/IAGA/vmod/igrf.html}
}
\seealso{
Use \code{\link{magneticField}} to determine the declination,
inclination and intensity at a given spot on the world, at a given time.

Other things related to magnetism: \code{\link{magneticField}}
}
\author{
Dan Kelley
}
