% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\docType{class}
\name{echosounder-class}
\alias{echosounder-class}
\title{Class to Store Echosounder Data}
\description{
Class to store echosounder data.
}
\details{
The \code{data} slot is a list containing

\itemize{

\item An infrequently updated record of the intrument position, in
\code{timeSlow}, \code{longitudeSlow} and \code{latitudeSlow}.  These are
used in plotting maps with \code{\link{plot,echosounder-method}}.

\item An interpolated record of the instrument position, in \code{time},
\code{longitude}, and \code{latitude}.  Linear interpolation is used to
infer the longitude and latitude from the variables listed above.

\item \code{depth}, vector of depths of echo samples (measured positive
downwards in the water column).  This is calculated from the inter-sample
time interval and the sound speed provided as the \code{soundSpeed} argument
to \code{\link{read.echosounder}}, so altering the value of the latter will
alter the echosounder plots provided by \code{\link{plot,echosounder-method}}.

\item The echosounder signal amplitude \code{a}, a matrix whose number of
rows matches the length of \code{time}, etc., and number of columns equal to
the length of \code{depth}.  Thus, for example, \code{a[100,]} represents
the depth-dependent amplitude at the time of the 100th ping.

\item A matrix named \code{b} exists for dual-beam and split-beam cases.
For dual-beam data, this is the wide-beam data, whereas \code{a} is the
narrow-beam data.  For split-beam data, this is the x-angle data.

\item A matrix named \code{c} exists for split-beam data, containing the
y-angle data.

\item In addition to these matrices, ad-hoc calculated matrices named
\code{Sv} and \code{TS} may be accessed as explained in the next section.

}
}
\section{Methods}{


\emph{Accessing values.} Data may be accessed as e.g.
\code{echosounder[["time"]]}, \code{echosounder[["depth"]]},
\code{echosounder[["a"]]}, etc.  Items in \code{metadata} must be specifield
by full name, but those in \code{data} may be abbreviated, so long as the
abbreviation is unique. In addition to the actual data, some derived fields
are also available: \code{echosounder[["distance"]]} calls
\code{\link{geodDist}} to compute calculate distance along the ship track,
\code{echosounder[["Sv"]]} returns a matrix of backscatter strength in DB,
and \code{echosounder[["TS"]]} returns a matrix of target strength in dB.

\emph{Assigning values.} Everything that may be accessed may also be
assigned, e.g.  \code{echosounder[["time"]] <- 3600 + echosounder[["time"]]}
adds an hour to time.
}
\author{
Dan Kelley

Statistical summaries are provided by \code{\link{summary,echosounder-method}},
while \code{\link{show}} displays an overview.  The \code{\link{findBottom}}
function infers the ocean bottom from tracing the strongest reflector from
ping to ping.

Echosounder objects may be plotted with \code{\link{plot,echosounder-method}}.

The contents of \code{echosounder} objects may be altered with
\code{\link{subset,echosounder-method}}, or with the \code{[[]]} scheme
discussed in the previous section; skilled users may also manipulate the
contents directly, but this is not recommended because it is brittle to
changes in the data structure.
}
\seealso{
Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}}, \code{\link{ctd-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}

Other things related to \code{echosounder} data: \code{\link{[[,echosounder-method}},
  \code{\link{[[<-,echosounder-method}},
  \code{\link{as.echosounder}}, \code{\link{echosounder}},
  \code{\link{findBottom}},
  \code{\link{plot,echosounder-method}},
  \code{\link{read.echosounder}},
  \code{\link{subset,echosounder-method}},
  \code{\link{summary,echosounder-method}}
}

