% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{decodeDataNames}
\alias{decodeDataNames}
\title{Try to guess data names from hints found in file headers}
\usage{
decodeDataNames(names, scheme)
}
\arguments{
\item{names}{a vector of character strings with original names}

\item{scheme}{an optional indication of the scheme that is employed. This may
be \code{"ODF"}, in which case \code{\link{ODFNames2oceNames}} is used,
or \code{"met"}, in which case some tentative code for met files is used.}
}
\value{
Vector of strings for the decoded names. If an unknown scheme is provided,
this will just be \code{names}.
}
\description{
Try to guess data names from hints found in file headers
}
\details{
Interoperability between oce functions requires that standardized data names
be used, e.g. \code{"temperature"} for in-situ temperature. Very few
data-file headers name the temperature column in exactly that way, however,
and this function is provided to try to guess the names.
}

