% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDeserializerDescriptors.R
\name{getDeserializerDescriptors}
\alias{getDeserializerDescriptors}
\title{Lists the descriptors of all registered deserializers.}
\usage{
getDeserializerDescriptors(labbcat.url)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}
}
\value{
A list of serializers, each including the following information:
\itemize{
 \item{\emph{name} The name of the format.}
 \item{\emph{version} The installed version of the serializer module.}
 \item{\emph{fileSuffixes} The normal file name suffixes (extensions) of the files.},
 \item{\emph{mimeType} The MIME type of the format, i.e. the value to use as the
    \emph{mimeType} parameter of \link{getFragments}},
}
}
\description{
Returns a list of deserializers, which are modules that import transcriptions and
annotation structures from a specific file format, e.g. Praat TextGrid, plain text, etc.
}
\examples{
\dontrun{
## List file upload formats supported
formats <- getDeserializerDescriptors("https://labbcat.canterbury.ac.nz/demo/")

## can we upload as plain text?
plainTextSupported <- "text/plain" \%in\% formats$mimeType
}

}
\keyword{format}
