% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMatchingTranscriptIds.R
\name{getMatchingTranscriptIds}
\alias{getMatchingTranscriptIds}
\title{Gets a list of IDs of transcripts that match a particular pattern.}
\usage{
getMatchingTranscriptIds(
  labbcat.url,
  expression,
  pageLength = NULL,
  pageNumber = NULL,
  order = NULL
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{expression}{An expression that determines which transcripts match}

\item{pageLength}{The maximum number of IDs to return, or null to return all}

\item{pageNumber}{The zero-based page number to return, or null to return the first page}

\item{order}{An expression that determines the order the transcripts are
listed in - if specified, this must include the keyword 'ASC' for ascending or 'DESC'
for descending order.}
}
\value{
A list of transcript IDs (i.e. transcript names)
}
\description{
Gets a list of IDs of transcripts (i.e. transcript names) that match a
particular pattern.
}
\details{
The results can be exhaustive, by omitting pageLength and
pageNumber, or they  can be a subset (a 'page') of results, by
given pageLength and pageNumber values.

The order of the list can be specified.  If ommitted, the transcripts
are listed in ID order.

The expression language is currently not well defined, but
expressions such as those in the examples can be used.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get all transcripts whose names start with "BR"
transcripts <- getMatchingTranscriptIds(labbcat.url, "id MATCHES 'BR.+'")

## Get the first twenty transcripts in the "QB" corpus
transcripts <- getMatchingTranscriptIds(
        labbcat.url, "my('corpus').label = 'QB'", 20, 0)

## Get the second transcript that has "QB247_Jacqui" as a speaker
transcripts <- getMatchingTranscriptIds(
        labbcat.url, "'QB247_Jacqui' IN labels('participant')", 1, 1)

## Get all transcripts whose names start with "BR" and have "QB247_Jacqui" as a speaker,
## in word-count order 
transcripts <- getMatchingTranscriptIds(
        labbcat.url, "my('corpus').label = 'QB' AND 'QB247_Jacqui' IN labels('participant')", 1, 1,
        "my('transcript_word_count').label ASC")
}

}
\keyword{expression}
\keyword{transcript}
