% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAnchors.R
\name{getAnchors}
\alias{getAnchors}
\title{Gets the given anchors in the given graph.}
\usage{
getAnchors(labbcat.url, id, anchorId)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A graph ID (i.e. transcript name)}

\item{anchorId}{A vector of anchor IDs (or a string representing one anchor ID)}
}
\value{
A named list of anchors, with members:
\itemize{
 \item{\emph{id} The annotation's unique ID},
 \item{\emph{offset} The offset from the beginning (in seconds if it's a
 transcript of a recording, or in characters if it's a text document)}
 \item{\emph{confidence} A rating from 0-100 of the confidence of the offset,
  e.g. 10: default value, 50: force-aligned, 100: manually aligned}
}
}
\description{
Lists the given anchors in the given graph (transcript).
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get the first 20 orthography tokens in UC427_ViktoriaPapp_A_ENG.eaf
orthography <- getAnnotations(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", "orthography", 20, 0)

## Get the start anchors for the above tokens
word.starts <- getAnchors(labbcat.url, "UC427_ViktoriaPapp_A_ENG.eaf", orthography$startId)
}

}
\seealso{
\link{getAnnotations}
}
\keyword{anchor}
