% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{env2dots}
\alias{env2dots}
\title{Copy bindings from an environment into a dots object, or vice versa.}
\usage{
env2dots(
  env = caller(environment()),
  names = ls(envir = env, all.names = TRUE),
  include_missing = TRUE,
  expand_dots = TRUE
)
}
\arguments{
\item{env}{An environment.}

\item{names}{Which names to extract from the environment. By
default extracts all bindings present in \code{env}, but not in
its enclosing environments.}

\item{include_missing}{Whether to include missing bindings.}

\item{expand_dots}{Whether to include the contents of \code{...}.}
}
\value{
A \link{dots} object.
}
\description{
\code{env2dots} copies all bindings in the environment (but not those
from its parents) into a new \link{dots} object. Bindings that are
promises will be captured without forcing. Bindings that are not
promises will be rendered as \link{forced} quotations. The output will
not be in any guaranteed order.
}
