% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_events_and_duration.R
\name{exp_events}
\alias{exp_events}
\title{Expected number of events}
\usage{
exp_events(arm0 = NA, arm1 = NA, tau = NA)
}
\arguments{
\item{arm0}{object of class 'arm'.}

\item{arm1}{object of class 'arm'.}

\item{tau}{vector of times. Defaults to total study duration.}
}
\value{
expected number of events.
}
\description{
Given one or two treatment arms, calculate the expected number
of events \eqn{d} at time \eqn{\tau}.
}
\examples{
arm0 <- create_arm(size=120, accr_time=6, surv_scale=0.05, loss_scale=0.005, follow_time=12)
arm1 <- create_arm(size=120, accr_time=6, surv_scale=0.03, loss_scale=0.005, follow_time=12)
exp_events(arm0)
exp_events(arm0, arm1)
exp_events(arm0, tau=c(10,NA))
exp_events(arm0, arm1, tau=c(10,NA))
}
\seealso{
\code{\link{exp_duration}} for calculating time to achieve expected
  events d, \code{\link{create_arm}} and \code{\link{create_arm_lachin}}
  for creating an object of class 'arm'.
}
