% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_arm.R
\name{create_arm}
\alias{create_arm}
\title{Create an 'arm' object}
\usage{
create_arm(size, accr_time, accr_dist = "pieceuni",
  accr_interval = c(0, accr_time), accr_param = NA, surv_cure = 0,
  surv_interval = c(0, Inf), surv_shape = 1, surv_scale,
  loss_shape = 1, loss_scale, follow_time = Inf, total_time = Inf)
}
\arguments{
\item{size}{sample size. If total sample size is unknown, provide
the integer sample size relative to the opposing arm, e.g. 1 for
1:2 randomization ratio or 2 for 2:3.}

\item{accr_time}{accrual duration.}

\item{accr_dist}{accrual distribution. Default is piecewise uniform.
Alternatively, 'truncexp' allows for a truncated exponential distribution
as proposed by Lachin and Foulkes (1986). Depending on the value of
\code{accr_param}, this distribution can be either convex or concave.}

\item{accr_interval}{accrual intervals. Defaults to the single interval
spanning from 0 to \code{accr_time}. If a piecewise uniform accrual
with more than one interval is desired, specify \code{accr_interval}
as the vector of increasing changepoints (knots) starting from 0 and
ending with \code{accr_time}, e.g. c(0, 2, 4) defines a piecewise
uniform distribution with two intervals, [0, 2) and [2, 4].}

\item{accr_param}{additional accrual parameter(s). For a piecewise uniform accrual
with more than one interval, specify \code{accr_param} as the vector of probabilities
a patient is enrolled in each interval. The probabilities should naturally sum to 1.
For \code{accr_dist}='truncexp', specify \code{accr_param} as a single number.
>0 results in a convex distribution and <0 results in a concave distribution.}

\item{surv_cure}{proportion of patients that are cured.}

\item{surv_interval}{survival intervals. Defaults to the single interval
spanning from 0 to infinity. If a piecewise exponential survival is
desired for uncured patients, specify \code{surv_interval} as the vector
of increasing changepoints (knots) starting from 0 and ending with infinity,
e.g. c(0, 6, 10, Inf).}

\item{surv_shape}{Weibull shape parameter for the survival distribution of
uncured patients.}

\item{surv_scale}{Weibull scale parameter for the survival distrubition of
uncured patients. Piecewise exponential survival may be defined by specifying
\code{surv_shape}=1 and \code{surv_scale} as the vector of piecewise hazard
rates.}

\item{loss_shape}{Weibull shape parameter for the loss to follow-up distribution.}

\item{loss_scale}{Weibull scale parameter for the loss to follow-up distribution.}

\item{follow_time}{follow-up duration.}

\item{total_time}{total study duration. Only 1 of the 2 parameters, \code{follow_time}
or \code{total_time}, need to be defined. If neither is defined, \code{total_time}
is defaulted to max value 1e6.}
}
\value{
a list containing assumptions of size, accrual, censoring, survival, and
  follow-up for a single arm.
}
\description{
Create an object of class 'arm' by specifying the trial parameters for
a single arm, including the sample size, accrual distribution,
survival distribution, loss to follow-up distribution, and study duration.
}
\examples{
# Example 1
example <- create_arm(size=120,
  accr_time=6,                   # uniform accrual
  surv_scale=0.05,               # exponential survival
  loss_scale=0.005,              # exponential loss to follow-up
  follow_time=12)
class(example)                   # this example also satisfies properties of subclass 'lachin'

# Example 2
create_arm(size=120,
  accr_time=6,                   # truncated exponential accrual
  accr_dist="truncexp",
  accr_param=0.1,
  surv_shape=2,                  # weibull survival
  surv_scale=0.05,
  loss_shape=1.5,                # weilbull loss to follow-up
  loss_scale=0.005,
  total_time=18)

# Example 3
create_arm(size=120,
  accr_time=6,
  accr_interval=c(0,2,4,6),      # piecewise uniform accrual
  accr_param=c(0.2,0.3,0.5),
  surv_cure=0.1,                 # 10\% cure fraction
  surv_interval=c(0,6,10,Inf),   # piecewise exponential survival for uncured patients
  surv_scale=c(0.05,0.04,0.03),
  loss_shape=0.7,                # weibull loss to follow-up
  loss_scale=0.005,
  total_time=18)
}
\references{
Lachin, J. M. and Foulkes, M. A. (1986) Evaluation of sample size and power for analyses of
  survival with allowance for nonuniform patient entry, losses to follow-up,
  noncompliance, and stratification. \emph{Biometrics}, \strong{42}, 507-519.
}
\seealso{
\code{\link{create_arm_lachin}} for creating an object of subclass 'lachin'.
}
