% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obfuscateId.R
\name{obfuscateId}
\alias{obfuscateId}
\title{obfucateId creates a vector of ID aliases of specified length}
\usage{
obfuscateId(id, size = 10, existingIds = character(0))
}
\arguments{
\item{id}{character vector of IDs to be obfuscated (alias creation).}

\item{size}{character length of each alias}

\item{existingIds}{character vector of existing aliases to avoid duplication.}
}
\value{
A named character vector of aliases where the name is the original
ID value.
}
\description{
ID aliases are pseudorandom sequences of alphanumeric upper case characters
where the letter "O" is not included for readability..
User has the option of providing a character vector of aliases to avoid
using.
}
\examples{
\donttest{
library(nprcgenekeepr)
integerIds <- 1:10
obfuscateId(integerIds, size = 4)
characterIds <- paste0(paste0(sample(LETTERS, 1, replace = FALSE)), 1:10)
obfuscateId(characterIds, size = 4)
}
}
