% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offspringCounts.R
\name{offspringCounts}
\alias{offspringCounts}
\title{Finds the total number of offspring for each animal in the pedigree}
\usage{
offspringCounts(probands, ped, considerPop = FALSE)
}
\arguments{
\item{probands}{character vector of egos for which offspring should be
counted.}

\item{ped}{the pedigree information in datatable format.  Pedigree
(req. fields: id, sire, dam, gen, population).
This is the complete pedigree.}

\item{considerPop}{logical value indication whether or not the number of
offspring that are part of the focal population are to be counted?
Default is \code{FALSE}.}
}
\value{
A dataframe with at least \code{id} and \code{totalOffspring}
required and \code{livingOffspring} optional.
}
\description{
Optionally find the number that are part of the population of interest.
}
\examples{
\donttest{
library(nprcgenekeepr)
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
focalAnimals <- breederPed$id[!(is.na(breederPed$sire) &
                                  is.na(breederPed$dam)) &
                                is.na(breederPed$exit)]
ped <- setPopulation(ped = breederPed, ids = focalAnimals)
trimmedPed <- trimPedigree(focalAnimals, breederPed)
probands <- ped$id[ped$population]
counts <- offspringCounts(probands, ped)
}

}
