% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likebut.R
\name{tweak.default}
\alias{tweak.default}
\title{Tweak a Model by Default}
\usage{
\method{tweak}{default}(x, project = getOption("project", getwd()),
  ext = getOption("modex", "ctl"), start = NULL, n = 10,
  include = ".def$", ...)
}
\arguments{
\item{x}{object}

\item{project}{project directory}

\item{ext}{file extension for control streams}

\item{start}{a number to use as the first modelname}

\item{n}{the number of variants to generate (named start:n)}

\item{include}{regular expressions for files to copy to new directory}

\item{...}{pass ext to over-ride default model file extension}
}
\value{
character: vector of names for models created
}
\description{
Tweaks a model by jittering initial estimates. Creates a new model directory
in project context and places the model there. Copies helper files as well.
Expects that x is a number. Assumes nested directory structure (run-specific directories).
}
\seealso{
Other tweak: \code{\link{tweak.inits}},
  \code{\link{tweak.init}}, \code{\link{tweak.model}},
  \code{\link{tweak}}
}
