% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMinimumEmbeddingDimension.R
\name{estimateEmbeddingDim}
\alias{estimateEmbeddingDim}
\title{Estimate the embedding dimension}
\usage{
estimateEmbeddingDim(
  time.series,
  number.points = length(time.series),
  time.lag = 1,
  max.embedding.dim = 15,
  threshold = 0.95,
  max.relative.change = 0.1,
  do.plot = TRUE,
  main = "Computing the embedding dimension",
  xlab = "dimension (d)",
  ylab = "E1(d) & E2(d)",
  ylim = NULL,
  xlim = NULL,
  std.noise
)
}
\arguments{
\item{time.series}{The original time series.}

\item{number.points}{Number of points from the time series that will be used 
to estimate the embedding dimension. By default, all the points in the time 
series are used.}

\item{time.lag}{Time lag used to build the Takens' vectors needed to 
estimate the embedding dimension (see \link{buildTakens}). Default: 1.}

\item{max.embedding.dim}{Maximum possible embedding dimension for the time 
series. Default: 15.}

\item{threshold}{Numerical value between 0 and 1. The embedding dimension is 
estimated using the E1(d) function. E1(d) stops changing when d is greater 
than or equal to embedding dimension, staying close to 1. This value 
establishes a threshold for considering that E1(d) is close to 1. 
Default: 0.95}

\item{max.relative.change}{Maximum relative change in E1(d) with respect to 
E1(d-1) in order to consider that the E1 function has been stabilized and it 
will stop changing. Default: 0.01.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of E1(d) and 
E2(d) is shown.}

\item{main}{Title for the plot.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{ylim}{numeric vectors of length 2, giving the y coordinates range.}

\item{xlim}{numeric vectors of length 2, giving the x coordinates range.}

\item{std.noise}{numeric value that permits to add a small amount of noise
to the original series to avoid the appearance of false neighbours due to 
discretizacion errors. This also prevents the method to fail with periodic
signals (in which neighbours at a distance of 0 appear). By default, a small
 amount of noise is always added. Use 0 not to add noise.}
}
\description{
This function determines the minimum embedding dimension from a scalar time 
series using the algorithm proposed by L. Cao (see references).
}
\details{
The Cao's algorithm uses 2 functions in order to estimate the embedding 
dimension from a time series: the E1(d) and the E2(d) functions, where d 
denotes the dimension.

E1(d) stops changing when d is greater than or equal to the embedding 
dimension, staying close to 1. On the other hand, E2(d) is used to 
distinguish deterministic signals from stochastic signals. For 
deterministic signals, there exist some d such that E2(d)!=1. For stochastic 
signals, E2(d) is approximately 1 for all the values. 

This function uses the Arya and Mount's C++ ANN library for nearest neighbour
 search (For more information on the ANN library please visit 
 \url{http://www.cs.umd.edu/~mount/ANN/}). The R wrapper is a modified 
 version of the RANN package code by Samuel E. Kemp and Gregory Jefferis.

If no suitable embedding dimension can be found within the provided range,
the function will return NA.
}
\note{
In the current version of the package, the automatic detection of stochastic 
signals has not been implemented yet.
}
\examples{
\dontrun{
h = henon(do.plot=FALSE) 
dimension = estimateEmbeddingDim(h$x, time.lag=1, max.embedding.dim=6,
             threshold=0.9, do.plot=TRUE)
             }
}
\references{
Cao, L. Practical method for determining the minimum embedding dimension of
 a scalar time series. Physica D: Nonlinear Phenomena, 110,1, 
 pp. 43-50 (1997).

Arya S. and Mount D. M. (1993), Approximate nearest neighbor searching, 
Proc. 4th Ann. ACM-SIAM Symposium on Discrete Algorithms (SODA'93), 271-280.

Arya S., Mount D. M., Netanyahu N. S., Silverman R. and Wu A. Y (1998), 
An optimal algorithm for approximate nearest neighbor searching, 
Journal of the ACM, 45, 891-923.
}
\author{
Constantino A. Garcia
}
