% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FindMLE_CONT_H0_hypergeoC}
\alias{FindMLE_CONT_H0_hypergeoC}
\title{Maximum Likelihood Estimate under the sharp null for Compliers.}
\usage{
FindMLE_CONT_H0_hypergeoC(n_y0x0z0, n_y1x0z0, n_y0x0z1, n_y1x0z1, n_y0x1z1,
  n_y1x1z1)
}
\arguments{
\item{n_y0x0z0}{Number of individuals with Y=0, X=0, Z=0.}

\item{n_y1x0z0}{Number of individuals with Y=1, X=0, Z=0.}

\item{n_y0x0z1}{Number of individuals with Y=0, X=0, Z=1.}

\item{n_y1x0z1}{Number of individuals with Y=1, X=0, Z=1.}

\item{n_y0x1z1}{Number of individuals with Y=0, X=1, Z=1.}

\item{n_y1x1z1}{Number of individuals with Y=1, X=1, Z=1.}
}
\value{
The maximum likelihood under the sharp null for Compliers,
    and the corresponding (possibly non-unique)
    total number of Compliers of response types
    Never Recover and Always Recover.
}
\description{
Find the maximum likelihood estimate of the 2 by 4 contingency table
    assuming only Compliers and Never Takers in the population,
    under the sharp null for Compliers
    and with the multivariate hypergeometric sampling distribution.
    This is the C++ function for the R wrapper function
    \code{\link{FindMLE_CONT_H0_hypergeoR}}.
}

