% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_noise_method.R
\name{remove_noise_method}
\alias{remove_noise_method}
\title{Function to remove the noisy reads from the expression matrix using a specified method}
\usage{
remove_noise_method(
  expression.matrix,
  method.chosen = "Boxplot-IQR",
  stats.df = NULL,
  abn.matrix = NULL,
  dist.matrix = NULL,
  dist.thresh = 0.25,
  binsize = 0.1,
  add.thresh = TRUE,
  average.thresh = TRUE,
  remove.noisy.features = TRUE,
  export.csv = NULL
)
}
\arguments{
\item{expression.matrix}{the expression matrix}

\item{method.chosen}{the method to be used for the noise removal;
must be one of get_methods_calculate_noise_threshold()}

\item{stats.df}{a tibble, as output by calculate_threshold_noise();
if supplied and the chosen method appears in it, the corresponding threshold is used directly.}

\item{abn.matrix, dist.matrix}{the input distance and abundance matrices as calculated by
calculate_distance_matrices(); only needed if stats.df is not supplied;
if either is not supplied, only a fixed threshold is
calculated based on the density}

\item{dist.thresh}{a distance threshold to be used if the noise thresholds are not
pre-calculated; the default 0.25 is suitable for correlation measures}

\item{binsize}{size of each bin in the boxplot methods; defaults to 0.1 (on a log-scale)}

\item{add.thresh}{whether to add the noise threshold to all values in the expression matrix
(default), or set entries below the threshold to the threshold}

\item{average.thresh}{if TRUE (default), uses tthe average of the vector of thresholds across all samples;
if FALSE, uses the thresholds as supplied}

\item{remove.noisy.features}{logical, whether rows of the expression matrix that are
fully under the noise threshold should be removed (default TRUE)}

\item{export.csv}{option to write the matrix into a csv after the noise removal;
should be NULL or the name of the output file.}
}
\value{
Returns a matrix of the same dims as the expression matrix, with the noise removed
using the specified method.
All entries below the noise threshold are replaced with the noise threshold.
}
\description{
This function is used to remove the noisy reads from the expression matrix.
It can use thresholds precalculated by calculate_threshold_noise(), if available.
If a vector of thresholds needs to be input manually, use remove_noise_matrix() instead.
}
\examples{
obj <- calculate_distance_matrices_counts(
    expression.matrix = matrix(1:100, ncol=5),
    method="correlation_pearson",
    n.elements.per.window=3)
remove_noise_method(
    expression.matrix=obj$exp,
    abn.matrix=obj$abn,
    dist.matrix=obj$dist)
}
