% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cast_gtf_to_genes.R
\name{cast_gtf_to_genes}
\alias{cast_gtf_to_genes}
\title{Function to extract exon names and positions from a gtf file}
\usage{
cast_gtf_to_genes(filename, feature = "exon")
}
\arguments{
\item{filename}{path to the gtf file}

\item{feature}{the feature to extract from the last column of the gtf/gff file;
default is exon}
}
\value{
Returns a tibble of the ids, names, chromosomes, start and end positions
of each exon found in the gtf file. If refGenome is installed, that is used
for the reading and is faster, otherwise the gtf is read manually with a warning
}
\description{
This function is used to extract all exons and their positions
in the genome from an input gtf file.
}
\examples{
fl <- system.file("extdata", "example.gtf.gz", package="Rsamtools", mustWork=TRUE)
genes <- cast_gtf_to_genes(fl)
}
