% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-fn.R
\name{as_fn}
\alias{as_fn}
\title{Minimal notation for functional arguments}
\usage{
as_fn(.f)
}
\arguments{
\item{.f}{A function or an abbreviated anonymous-function expression of the
form \code{.(...)}, where \code{...} is a \link[=fn]{function declaration} (i.e., \code{.}, in
this context, is an alias of \code{\link[=fn]{fn()}}). As for \code{\link[=fn]{fn()}},
\link[rlang:quasiquotation]{quasiquotation} is supported.}
}
\value{
If \code{.f} is a function, it is simply returned, otherwise the function
determined by the \link[=fn]{function declaration} is returned.
}
\description{
\code{as_fn()} is for functions that take functional arguments. Use \code{as_fn()}
\emph{inside} a function to enable it to comprehend a minimal anonymous-function
notation for arguments that are functions. This notation is that of \code{\link[=fn]{fn()}},
but with \sQuote{\code{fn}} replaced by a single dot (\sQuote{\code{.}}).
}
\details{
\code{as_fn()} cannot follow promise expressions across function calls.
It is only intended to work in the immediate context in which a function
declaration is to be interpreted (see \emph{Examples}).
}
\examples{
call_fn <- function(.f, x) {
  f <- as_fn(.f)
  f(x)
}
call_fn(log, 1)
call_fn(.(. ~ sin(.) ^ 2), 1)
# simplified function expressions support quasiquotation
f <- sin
call_fn(.(. ~ UQ(f)(.) ^ 2), 1)

## wrap Map() to accept abbreviated anonymous function expressions
Map_ <- function (f, ...) {
  f <- as_fn(f)
  mapply(FUN = f, ..., SIMPLIFY = FALSE)
}
# you can call Map_() just like Map()
Map_(function(x, y, z) paste(x, y, paste("and", z), sep = ", "), 1:3, 4:6, 7:9)
# or use a simplified function expression
Map_(.(x, y, z ~ paste(x, y, paste("and", z), sep = ", ")), 1:3, 4:6, 7:9)

## abbreviated anonymous functions are interpreted in the calling environment
# so this works, as expected
foo <- function(a) as_fn(a)
foo(.(x ~ x + 1))
# but as_fn() can't interpret abbreviated anonymous functions across calls
foo <- function(a) bar(a)
bar <- function(b) as_fn(b)
\dontrun{
foo(.(x ~ x + 1))}

}
\seealso{
\code{\link[=fn]{fn()}}
}
