% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsZnnsym.dx}
\alias{funsZnnsym.dx}
\alias{Znnsym.dx.ct}
\alias{Znnsym.dx}
\title{Dixon's Pairwise NN Symmetry Test with Normal Approximation}
\usage{
Znnsym.dx.ct(
  ct,
  varS,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnsym.dx(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Znnsym.dx.ct} only}

\item{varS}{The variance vector of differences of off-diagonal cell counts in NNCT, \code{ct} , usually output 
of var.nnsym function.}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{ij}-N_{ji}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnsym.dx} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnsym.dx} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Znnsym.dx} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of \eqn{Z} test statistics for Dixon's NN symmetry test
(in the upper-triangular form)}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values for the hypothesis test for the corresponding alternative
(in the upper-triangular form)}
\item{LCL,UCL}{Matrix of Lower and Upper Confidence Levels (in the upper-triangular form) for the \eqn{N_{ij}-N_{ji}}
values for \eqn{i \ne j} at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{conf.int}{The confidence interval for the estimates, it is \code{NULL} here, since we provide the \code{UCL} and \code{LCL}
in \code{matrix} form.}
\item{cnf.lvl}{Level of the upper and lower confidence limits (i.e., conf.level) of the differences of the
off-diagonal entries.}
\item{estimate}{Estimates of the parameters, i.e., matrix of the difference of the off-diagonal entries
(in the upper-triangular form) of the \eqn{k \times k} NNCT, \eqn{N_{ij}-N_{ji}} for \eqn{i \ne j}.}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null value for the expected difference between the off-diagonal entries, 
\eqn{E(N_{ij})-E(N_{ji})} for \eqn{i \ne j} in the \eqn{k \times k} NNCT, which is 0 for this function.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Znnsym.dx.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Znnsym.dx} only}
}
\description{
Two functions: \code{Znnsym.dx.ct} and \code{Znnsym.dx}.

Both functions are objects of class \code{"cellhtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected values of the off-diagonal 
cell counts (i.e., entries) for each pair \eqn{i,j} of classes under RL or CSR in the NNCT for \eqn{k \ge 2} classes.
That is, each performs Dixon's NN symmetry test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

Each symmetry test is based on the normal approximation of the difference of the off-diagonal entries
in the NNCT and are due to \insertCite{dixon:1994;textual}{nnspat}.

Each function yields a contingency table of the test statistics, \eqn{p}-values for the corresponding 
alternative, expected values (i.e. null value(s)), lower and upper confidence levels and sample estimates (i.e. observed values)
for the \eqn{N_{ij}-N_{ji}} values for \eqn{i \ne j} (all in the upper-triangular form except for the null value, which is 0
for all pairs) and also names of the test statistics, estimates, null values and the method and the data
set used.

The null hypothesis is that all \eqn{E(N_{ij})=E(N_{ji})} for \eqn{i \ne j} in the \eqn{k \times k} NNCT (i.e., symmetry in the 
mixed NN structure) for \eqn{k \ge 2}.
In the output, the test statistic, \eqn{p}-value and the lower and upper confidence limits are valid  
for completely mapped data.

See also
(\insertCite{dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

varS<-var.nnsym(covN)

Znnsym.dx(Y,cls)
Znnsym.dx.ct(ct,varS)

Znnsym.dx(Y,cls,method="max")

Znnsym.dx(Y,cls,alt="g")
Znnsym.dx.ct(ct,varS,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Znnsym.dx(Y,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv) #default is byrow

varS<-var.nnsym(covN)

Znnsym.dx(Y,cls)
Znnsym.dx.ct(ct,varS)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym2cl.dx.ct}}, \code{\link{Znnsym2cl.dx}}, \code{\link{Znnsym.ss.ct}},
\code{\link{Znnsym.ss}}, \code{\link{Xsq.nnsym.dx.ct}} and \code{\link{Xsq.nnsym.dx}}
}
\author{
Elvan Ceyhan
}
