% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsW345values}
\alias{funsW345values}
\alias{W3val}
\alias{W4val}
\alias{W5val}
\title{\eqn{W_k} values for Tango's \eqn{T} test statistic}
\usage{
W3val(a)

W4val(a)

W5val(a)
}
\arguments{
\item{a}{\eqn{A_{ij}} matrix which is the output of the function \code{\link{aij.mat}}.}
}
\value{
Each function \code{Wkval} returns the \eqn{W_k} value for \eqn{k=3,4,5}.
}
\description{
Three functions: \code{W3val}, \code{W4val} and \code{W5val}, each of which is needed to compute \eqn{E[T^3]}
(i.e., for the skewness of \eqn{T})
where \eqn{T=T(\theta)} which is defined in Equation (2) of \insertCite{tango:2007;textual}{nnspat} as follows:
Let \eqn{(z_1,\ldots,z_n )}, \eqn{n = n_0 + n_1}, denote the locations of the points in the combined sample 
when the indices have been randomly permuted so that the \eqn{z_i} contain no information about group membership.
\deqn{T(\theta)=\sum_{i=1}^{n}\sum_{j=1}^{n}\delta_i \delta_j a_{ij}(\theta)=
\boldsymbol \delta^t \boldmath A(\theta)) \boldsymbol \delta} where \eqn{\delta_i=1} if \eqn{z_i} is a case,
and 0 if \eqn{z_i} is a control,  \eqn{\boldmath A(\theta) = (a_{ij} (\theta))} could be any matrix of a measure of
the closeness between two points \eqn{i} and \eqn{j} with \eqn{a_{ii} = 0} for all \eqn{i = 1,\ldots,n}, and \eqn{\boldsymbol \theta = 
(\theta_1,\ldots,\theta_p)^t} denotes the unknown parameter vector related to cluster size and 
\eqn{\boldsymbol \delta = (\delta_1,\ldots,\delta_n)^t}. 
Here the number of cases are denoted as \eqn{n_1} and number of controls as \eqn{n_0}  to match the case-control class
labeling, which is just the reverse of the labeling in \insertCite{tango:2007;textual}{nnspat}.

If \eqn{\theta=k} in the nearest neighbors model with \eqn{a_{ij}(k) = 1} if \eqn{z_j} is among the \eqn{k}NNs of \eqn{z_i} and 0 
otherwise, then the test statistic \eqn{T(\theta) = T_k} is the Cuzick and Edwards \eqn{k}NN test statistic, \eqn{T_k}
\insertCite{cuzick:1990;textual}{nnspat}, see also \code{\link{ceTk}}.

\eqn{W_k} values are used for Tango's correction to Cuzick and Edwards \eqn{k}NN test statistic, \eqn{T_k} and
\eqn{W_k} here corresponds to \eqn{W_{k-1}} in \insertCite{tango:2007;textual}{nnspat}
(defined for consistency with \eqn{p_k}'s and \eqn{alpha_r} having \eqn{r} distinct elements).

The argument of the function is the \eqn{A_{ij}} matrix, \code{a}, which is the output of the function \code{\link{aij.mat}}.
However, inside the function we symmetrize the matrix \code{a} as \code{b <- (a+a^t)/2}, to facilitate the formulation.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
k<-sample(1:5,1) # try also 3, 5, sample(1:5,1)
k
a<-aij.mat(Y,k)
W3val(a)
W4val(a)
W5val(a)

a<-aij.mat(Y,k,method="max")
W3val(a)
W4val(a)
W5val(a)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{EV.Tk}}, \code{\link{varTk}}, \code{\link{Xsq.ceTk}}
}
\author{
Elvan Ceyhan
}
