% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsExpTk}
\alias{funsExpTk}
\alias{EV.Tk}
\alias{EV.Tkaij}
\title{Expected Value for Cuzick and Edwards \eqn{T_k} Test statistic}
\usage{
EV.Tk(k, n1, n0)

EV.Tkaij(k, n1, a)
}
\arguments{
\item{k}{Integer specifying the number of NNs (of subject \eqn{i}).}

\item{n1, n0}{The number of cases and controls, \eqn{n_1} used for both functions, and \eqn{n_0} used in \code{EV.Tk} only.}

\item{a}{The \eqn{A=(a_{ij})} matrix}
}
\value{
The expected value of Cuzick and Edwards \eqn{T_k} test statistic for disease clustering
}
\description{
Two functions: \code{EV.Tk} and \code{EV.Tkaij}.

Both functions compute the expected value of Cuzick and Edwards \eqn{T_k} test statistic based on the number of cases 
within \code{k}NNs of the cases in the data under RL or CSR independence.

The number of cases are denoted as \eqn{n_1} (denoted as \code{n1} as an argument)
for both functions and number of controls as \eqn{n_0} (denoted as \code{n0} as an argument) in \code{EV.Tk},
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

The function \code{EV.Tkaij} uses Toshiro Tango's moments formulas based on the \eqn{A=(a_{ij})} matrix
(and is equivalent to the function \code{EV.Tk}, see \insertCite{tango:2007;textual}{nnspat},
where \eqn{a_{ij}(k) = 1} if \eqn{z_j} is among the \code{k}NNs of \eqn{z_i} and 0 otherwise.

See also (\insertCite{ceyhan:SiM-seg-ind2014;textual}{nnspat}).
}
\examples{
n1<-20
n0<-25
k<-1 #try also 3, 5, sample(1:5,1)

EV.Tk(k,n1,n0)

###
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)
n1<-sum(cls==1)
n0<-sum(cls==0)
a<-aij.mat(Y,k)

EV.Tk(k,n1,n0)
EV.Tkaij(k,n1,a)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}} and \code{\link{EV.Tcomb}}
}
\author{
Elvan Ceyhan
}
