% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{ceTkinv}
\alias{ceTkinv}
\title{Cuzick and Edwards \eqn{T_k^{inv}} Test statistic}
\usage{
ceTkinv(dat, k, cc.lab, case.lab = NULL, ...)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{k}{Integer specifying the number of the closest controls to subject \eqn{i}.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with two elements
\item{Tkinv}{Cuzick and Edwards \eqn{T_k^{inv}} test statistic for disease clustering}
\item{run.vec}{The \code{vector} of number of cases till the \code{k}-th control for each point in the data set}
}
\description{
This function computes Cuzick and Edwards \eqn{T_k^{inv}} test statistic based on the sum of number of cases closer to 
each case than the \code{k}-th nearest control to the case.

\eqn{T_k^{inv}} test statistic is an extension of the run length test allowing a fixed number of controls in the run 
sequence. 

\eqn{T_k^{inv}} test statistic is defined as \eqn{T_k^{inv}=\sum_{i=1}^n \delta_i \nu_i^k} where \eqn{\delta_i=1} 
if \eqn{z_i} is a case, and 0 if \eqn{z_i} is a control and \eqn{\nu_i^k} is the number of cases closer
to the index case than the \code{k} nearest control, i.e., number of cases encountered beginning
at \eqn{z_i} until \code{k}-th control is encountered. 
 
The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL},
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's and 1's
accordingly.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
cls
k<-2 #also try 3,4

ceTkinv(Y,k,cls)
ceTkinv(Y,k,cls+1,case.lab = 2)
ceTkinv(Y,k,cls,method="max")

ceTrun(Y,cls)
ceTkinv(Y,k=1,cls)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ceTkinv(Y,k,fcls,case.lab="a") #try also ceTrun(Y,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #here ceTkinv(Y,k,cls) #gives error

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTrun}}, \code{\link{ceTk}}, and \code{\link{Tcomb}}
}
\author{
Elvan Ceyhan
}
