% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSlogisJN.R
\name{SSlogisJN}
\alias{SSlogisJN}
\title{Alternative self start for three-parameter logistic function SSlogis}
\usage{
SSlogisJN(input, Asym, xmid, scal)
}
\arguments{
\item{input}{input vector (input)}

\item{Asym}{asymptotic value for large values of x}

\item{xmid}{a numeric parameter representing the x value at the inflection point of 
the curve. The value of SSlogisJN will be Asym/2 at xmid.}

\item{scal}{numeric scale parameter on the input axis}
}
\description{
Self starter for a 3-parameter logistic function.

The equation for this function is:

\deqn{f(input) = Asym/(1 + exp((xmid - input)/scal))}

The approach of the function SSlogis() in base R uses a different
algorithm and returns the actual solution rather than starting
parameters, so runs a complete set of iterations, only to try to
repeat from the solution with the standard algorithm.
}
\references{
  Ratkowsky, David A. (1983) Nonlinear Regression Modeling, A Unified
      Practical Approach, Dekker: New York, section 8.3.2
}
\examples{
{
## require(ggplot2)
require(nlsr)
set.seed(1234)
x <- seq(0, 20, .2)
y <- SSlogisJN(x, 5, 10, .5) + rnorm(length(x), 0, 0.15)
frm<-y ~ SSlogisJN(x, Asym, xmid, scal)
dat <- data.frame(x = x, y = y)
strt<-getInitial(frm, dat)
cat("Proposed start:\n"); print(strt)
fit <- nlxb(frm, strt, data = dat, control=list(japprox="SSJac"))
print(fit)
## plot
## ggplot(data = dat, aes(x = x, y = y)) + 
##   geom_point() + 
##  geom_line(aes(y = fitted(fit)))
}
}
