% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cholSE}
\alias{cholSE}
\title{Generalized Cholesky Matrix Decomposition}
\usage{
cholSE(matrix, tol = (.Machine$double.eps)^(1/3))
}
\arguments{
\item{matrix}{Matrix to be Factorized.}

\item{tol}{Tolerance; Algorithm suggests (.Machine$double.eps) ^ (1 / 3), default}
}
\value{
Generalized Cholesky decomposed matrix.
}
\description{
Performs a (modified) Cholesky factorization of the form
}
\details{
t(P) \%*\% A \%*\% P  + E = t(R) \%*\% R

As detailed in Schnabel/Eskow (1990)
}
\note{
This version does not pivot or return the E matrix
}
\references{
matlab source: http://www.dynare.org/dynare-matlab-m2html/matlab/chol_SE.html; Slightly different return values

Robert B. Schnabel and Elizabeth
Eskow. 1990. "A New Modified Cholesky Factorization," SIAM Journal
of Scientific Statistical Computing, 11, 6: 1136-58.

Elizabeth Eskow and Robert B. Schnabel
1991. "Algorithm 695 - Software for a New Modified Cholesky Factorization,"
ACM Transactions on Mathematical Software, Vol 17, No 3: 306-312
}
\author{
Matthew L. Fidler (translation), Johannes Pfeifer, Robert
    B. Schnabel and Elizabeth Eskow
}
