% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlme_fit.R
\name{nlme_ode}
\alias{nlme_ode}
\alias{nlmeOde}
\title{Fit nlme-based mixed-effect model using ODE implementation}
\usage{
nlme_ode(dat.o, model, parModel, parTrans, response,
  responseScaler = NULL, transitAbs = FALSE, atol = 1e-06,
  rtol = 1e-04, maxsteps = 5000, hmin = 0, hmax = NULL, hini = 0,
  maxordn = 12, maxords = 5, debugODE = FALSE, mcCores = 1, ...)

nlmeOde(dat.o, model, parModel, parTrans, response,
  responseScaler = NULL, transitAbs = FALSE, atol = 1e-06,
  rtol = 1e-04, maxsteps = 5000, hmin = 0, hmax = NULL, hini = 0,
  maxordn = 12, maxords = 5, debugODE = FALSE, mcCores = 1, ...)
}
\arguments{
\item{dat.o}{data to be fitted}

\item{model}{a string containing the set of ordinary differential equations (ODE) and other expressions defining the changes in the dynamic  system. For details, see the sections \dQuote{Details} and  \dQuote{\code{RxODE Syntax}} below.}

\item{parModel}{list: model for fixed effects, randoms effects and initial values.}

\item{parTrans}{function: calculation of PK parameters}

\item{response}{names of the response variable}

\item{responseScaler}{optional response variable scaler. default is NULL}

\item{transitAbs}{boolean indicating if this is a transit
compartment absorption}

\item{atol}{a numeric absolute tolerance (1e-8 by default) used
by the ODE solver to determine if a good solution has been
achieved;  This is also used in the solved linear model to check
if prior doses do not add anything to the solution.}

\item{rtol}{a numeric relative tolerance (1e-6 by default) used
by the ODE solver to determine if a good solution has been
achieved. This is also used in the solved linear model to check
 if prior doses do not add anything to the solution.}

\item{maxsteps}{maximum number of (internally defined) steps allowed
during one call to the solver. (5000 by default)}

\item{hmin}{The minimum absolute step size allowed. The default
value is 0.}

\item{hmax}{The maximum absolute step size allowed.  The default
checks for the maximum difference in times in your sampling and
events, and uses this value.  The value 0 is equivalent to
infinite maximum absolute step size.}

\item{hini}{The step size to be attempted on the first step. The
default value is determined by the solver (when hini = 0)}

\item{maxordn}{The maximum order to be allowed for the nonstiff
(Adams) method.  The default is 12.  It can be between 1 and
12.}

\item{maxords}{The maximum order to be allowed for the stiff (BDF)
method.  The default value is 5.  This can be between 1 and 5.}

\item{debugODE}{a logical if debugging is enabled}

\item{mcCores}{number of cores used in fitting (only for Linux)}

\item{...}{additional nlme options}
}
\description{
'nlme_ode' fits a mixed-effect model described using ordinary differential
equation (ODEs). The ODE-definition follows RxODE syntax.
Specification of fixed effects, random effects and intial values follows
the standard nlme notations.
}
\details{
The ODE-based model specification may be coded inside a character
   string or in a text file, see Section \emph{RxODE Syntax} below for
   coding details.  An internal \code{RxODE} compilation manager object
   translates the ODE system into C, compiles it, and dynamically loads the
   object code into the current R session.  The call to \code{RxODE}
   produces an object of class \code{RxODE} which consists of a list-like
   structure (closure) with various member functions (see Section
   \emph{Value} below).
}
\section{RxODE Syntax}{


   An \code{RxODE} model specification consists of one or more
   statements terminated by semi-colons, \sQuote{\code{;}}, and
   optional comments (comments are delimited by \code{#} and an
   end-of-line marker).  \strong{NB:} Comments are not allowed
   inside statements.

   A block of statements is a set of statements delimited by
   curly braces, \sQuote{\code{\{ ... \}}}.
   Statements can be either assignments or conditional \code{if}
   statements. Assignment statements can be either \dQuote{simple}
   assignments, where the left hand is an identifier (i.e., variable), or
   special \dQuote{time-derivative} assignments, where the left hand
   specifies the change of that variable with respect to time
   e.g., \code{d/dt(depot)}.

   Expressions in assignment and \sQuote{\code{if}} statements can be
   numeric or logical (no character expressions are currently supported).
   Numeric expressions can include the following numeric operators
   (\sQuote{\code{+}}, \sQuote{\code{-}}, \sQuote{\code{*}},
   \sQuote{\code{/}}, \sQuote{\code{^}}),   and
   those mathematical functions defined in the C or the
   R math libraries (e.g., \code{fabs}, \code{exp}, \code{log}, \code{sin}).
   (Note that the modulo operator \sQuote{\code{\%}} is currently
   not supported.)

   Identifiers in an \code{RxODE} model specification can refer to:
   \itemize{
      \item state variables in the dynamic system (e.g., compartments in a
      pharmacokinetic/pharmacodynamic model);
      \item implied input variable, \code{t} (time),
      \code{podo} (oral dose, for absorption models), and
      \code{tlast} (last time point);
      \item model parameters, (\code{ka} rate of absorption, \code{CL}
      clearance, etc.);
      \item others, as created by assignments as part of the model
      specification.
   }

   Identifiers consist of case-sensitive alphanumeric characters,
   plus the underscore \sQuote{_} character.  \strong{NB:} the
   dot \sQuote{.} character is \strong{not} a valid character
   identifier.

   The values of these variables at pre-specified time points are
   saved as part of the fitted/integrated/solved model (see
   \code{\link{eventTable}}, in particular its member function
   \code{add.sampling} that defines a set of time points at which
   to capture a snapshot of the system via the values of these variables).

   The ODE specification mini-language is parsed with the help of
   the open source tool \emph{DParser}, Plevyak (2015).
}

\examples{
\dontrun{
library(nlmixr)
ode <- "
d/dt(depot) =-KA*depot;
d/dt(centr) = KA*depot - KE*centr;
"
dat <- read.table(system.file("examples/theo_md.txt", package = "nlmixr"), head=TRUE)
mypar <- function(lKA, lKE, lCL)
{
    KA=exp(lKA)
    KE=exp(lKE)
    CL=exp(lCL)
    V = CL/KE
}

specs <- list(fixed=lKA+lKE+lCL~1, random = pdDiag(lKA+lCL~1),
     start=c(lKA=0.5, lKE=-2.5, lCL=-3.2))

fit <- nlme_ode(theo_md, model=ode, par_model=specs, par_trans=mypar,
     response="centr", response.scaler="V",control=nlmeControl(pnlsTol=0.1))

}
}
\author{
Wenping Wang, Mathew Fidler
}
