% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_nitrc_file.R
\name{download_nitrc_file}
\alias{download_nitrc_file}
\title{Download NITRC file}
\usage{
download_nitrc_file(file_path, destfile = NULL, prefix = NULL,
  verbose = FALSE, error = FALSE)
}
\arguments{
\item{file_path}{Path to the file to be dowloaded}

\item{destfile}{Destination filename}

\item{prefix}{Prefix the file name with this (prevents
overwritting of same name files in case function is
used to download multiple scan types at once)}

\item{verbose}{Should progress be added to download?}

\item{error}{Should function error if download failed?}
}
\value{
Display path to the downloaded file
}
\description{
Download a single file from NITRC
}
\examples{
## file_path is retrieved using the get_scan_resources() function
\dontrun{r <- get_scan_resources('NITRC_IR_E10453')}
\dontrun{download_nitrc_file(r$URI[1])}
}
