% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dLogisticExponentialGrowth.R
\name{dLogisticExponentialGrowth}
\alias{dLogisticExponentialGrowth}
\alias{rLogisticExponentialGrowth}
\title{Logistic-Exponential Growth Model}
\usage{
dLogisticExponentialGrowth(x, a, b, r1, r2, k, mu, log)

rLogisticExponentialGrowth(n, a, b, r1, r2, k, mu)
}
\arguments{
\item{x}{vector of calendar years (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{r1}{growth rate of the logistic phase.}

\item{r2}{growth rate of exponential phase.}

\item{k}{initial proportion of the carrying capacity (must be between 0 and 1).}

\item{mu}{change point (in BP).}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\value{
For \code{dLogisticExponentialGrowth}: the probability (or likelihood) or log probability of an observed date x (in Cal BP). For \code{rLogisticExponentialGrowth} a simulated date in Cal BP.
}
\description{
Density and random generation of a logistic-exponential growth model distribution.
}
\examples{
p = list(r1=0.01,r2=-0.001,k=0.001,mu=4500)
modelPlot(model = dLogisticExponentialGrowth,a=6000,b=4000,params=p,alpha = 1)
}
\author{
Robert DiNapoli & Enrico Crema
}
