% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpAaCNOd/file312c5023de49
\name{make_MCMC_comparison_pages}
\alias{make_MCMC_comparison_pages}
\title{Make html pages summarizing results from compareMCMCs}
\usage{
make_MCMC_comparison_pages(comparisonResults, dir = ".", pageComponents,
  modelNames = names(comparisonResults), control, plot = TRUE)
}
\arguments{
\item{comparisonResults}{An object returned by \code{\link{compareMCMCs}} (or \code{\link{combine_MCMC_comparison_results}} or \code{\link{rename_MCMC_comparison_method}}).}

\item{dir}{Directory in which to generate html output (default is current working directory)}

\item{pageComponents}{An optional named list indicating which components to include in the html page for each MCMC method.  Each element should be TRUE or FALSE.  Options include: \code{timing} (default FALSE): a table of computation times, which is not very useful by itself without information about mixing.  \code{efficiencySummary} (default FALSE): A summary of minimum and mean MCMC efficiencies (over all top-level parameters), defined as effective sample size / computation time.  \code{efficiencySummaryAllParams} (default TRUE): Like \code{efficiencySummary}, but with the addition of a figure that shows the MCMC efficiency for each top-level parameter. \code{efficiencySummaryAllParams} (default TRUE): Like \code{efficiencySummaryAllParams}, but showing MCMC Pace, defined as 1/MCMC Efficiency.  \code{efficiencyDetails} (default TRUE) grid of efficiency barplots for each top-level parameter.  \code{posteriorSummary} (default TRUE): grid of mean, median, and 95\% credible interval for each top-level parameter.}

\item{modelNames}{names to use for the models.  By default these will be taken from \code{comparisonResults}.}

\item{control}{Optional list with elements \code{makeTopPage} and/or \code{mainPageName}.  \code{makeTopPage} has to do with whether an html index page should be generated to link to the results from each model in the \code{comparisonResults}.  \code{makeTopPage}  can take values 'yes', 'no', and 'if_needed', where the last case indicates to make an index page only if there is more than one model in \code{comparisonResults}.  \code{mainPageName} gives a name for the html file if it is generated, with default 'main' (to which '.html') is appended.}

\item{plot}{If TRUE, the html files are actually generated.  If FALSE, they are not generated, and instead a list with the figures is returned.  Each element of the list can be rendered as the argument of \code{print} or \code{plot}.}
}
\value{
See argument \code{plot}
}
\description{
This function is extensible: new html elements can be provided, but at the moment it is not very user-friendly to do so.
}
\details{
Effective sample size (ESS) is calculated using the \code{coda} packages \code{effectiveSize} function.  In cases of poot mixing, this can over-estimate ESS by not using a sufficiently high-order auto-regressive model in the estimation procudure.  See \code{\link{updateMCMCcomparisonWithHighOrderESS}} for other options.
}

