% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{team_game_report}
\alias{team_game_report}
\title{Access various reports for a season, game type, and category for all
the teams by game}
\usage{
team_game_report(
  season = season_now(),
  game_type = game_type_now(),
  category = "summary"
)
}
\arguments{
\item{season}{integer in YYYYYYYY (e.g., 20242025); see \code{\link[=seasons]{seasons()}} for
reference}

\item{game_type}{integer in 1:3 (where 1 = pre-season, 2 = regular season, 3
= playoff/post-season) OR character of 'pre', 'regular', or
playoff'/'post'; see \code{\link[=seasons]{seasons()}} for reference; most functions will NOT
support pre-season}

\item{category}{character (e.g., 'leadingtrailing'); see
\code{\link[=team_report_configurations]{team_report_configurations()}} for reference}
}
\value{
data.frame with one row per game per team
}
\description{
\code{team_game_report()} scrapes various reports for a given set of \code{season},
\code{game_type}, and \code{category} for all the teams by game.
}
\examples{
situational_team_game_report_playoffs_20212022 <- team_game_report(
  season    = 20212022, 
  game_type = 3, 
  category  = 'leadingtrailing'
)
}
