% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_add_xpass.R
\name{add_xpass}
\alias{add_xpass}
\title{Add expected pass columns}
\usage{
add_xpass(pbp, ...)
}
\arguments{
\item{pbp}{is a Data frame of play-by-play data scraped using \code{\link{fast_scraper}}.}

\item{...}{Additional arguments passed to a message function (for internal use).}
}
\value{
The input Data Frame of the parameter \code{pbp} with the following columns
added:
\describe{
\item{xpass}{Probability of dropback scaled from 0 to 1.}
\item{pass_oe}{Dropback percent over expected on a given play scaled from 0 to 100.}
}
}
\description{
Build columns from the expected dropback model will return \code{NA} on data prior to 2006
since that was before NFL started marking scrambles. Must be run on a dataframe that has already had
\code{\link{clean_pbp}} run on it, such as data from the data repository or
\code{\link{build_nflfastR_pbp}} or built using the database function \code{\link{update_db}}.
}
