% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform.R
\docType{methods}
\name{transform_clr}
\alias{transform_clr}
\alias{transform_clr-method}
\alias{transform_clr,CompositionMatrix-method}
\title{Centered Log-Ratios (CLR)}
\usage{
transform_clr(object, ...)

\S4method{transform_clr}{CompositionMatrix}(object, weights = FALSE)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{weights}{A \code{\link{logical}} scalar: sould a varying weight be used. If
\code{FALSE} (the default), equally-weighted parts are used. Alternatively, a
positive \code{\link{numeric}} vector of weights can be specified.}
}
\value{
A \code{\linkS4class{CLR}} object.
}
\description{
Computes CLR transformation.
}
\details{
The CLR transformation computes the log of each part relative to the
geometric mean of all parts.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Pairwise log-ratio
lr <- transform_lr(coda)

## Centered log-ratio
clr <- transform_clr(coda)

## Additive log-ratio
alr <- transform_alr(coda)

## Isometric log-ratio
ilr <- transform_ilr(coda)
plr <- transform_plr(coda)

## Inverse transformation
inv_clr <- transform_inverse(clr)
all.equal(coda, inv_clr)

inv_alr <- transform_inverse(alr)
all.equal(coda, inv_alr)

inv_ilr <- transform_inverse(ilr)
all.equal(coda, inv_ilr)

inv_plr <- transform_inverse(plr)
all.equal(coda, inv_plr)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Greenacre, M. J. (2021). Compositional Data Analysis. \emph{Annual Review of
Statistics and Its Application}, 8(1): 271-299.
\doi{10.1146/annurev-statistics-042720-124436}.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_alr}()},
\code{\link{transform_ilr}()},
\code{\link{transform_inverse}()},
\code{\link{transform_lr}()},
\code{\link{transform_plr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
