% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchlight.R
\name{clustered_searchlight}
\alias{clustered_searchlight}
\title{Create a clustered searchlight iterator}
\usage{
clustered_searchlight(mask, cvol = NULL, csize = NULL)
}
\arguments{
\item{mask}{A \code{\linkS4class{NeuroVol}} object representing the brain mask.}

\item{cvol}{An optional \code{ClusteredNeuroVol} instance representing pre-defined
clusters within the mask. If provided, the 'csize' parameter is ignored.}

\item{csize}{An optional integer specifying the number of clusters to be
generated using k-means clustering (ignored if \code{cvol} is provided).}
}
\value{
A \code{deferred_list} object containing \code{ROIVol} objects, each
  representing a clustered region within the image volume.
}
\description{
This function generates a searchlight iterator that iterates over successive
spatial clusters in an image volume. It allows for the exploration of spatially
clustered regions within the provided mask by using either a pre-defined
clustered volume or performing k-means clustering to generate the clusters.
}
\examples{
# Load an example brain mask
mask <- read_vol(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))

# Generate a clustered searchlight iterator with 5 clusters
clust_searchlight <- clustered_searchlight(mask, csize = 5)


}
